ALTER FUNCTION [dbo].[exportVMP] 
(
	@id_files int
	,@name_file varchar(20)
)
RETURNS varchar(max)
AS
BEGIN
	DECLARE @xml varchar(max);

with Wpacient as (
	select   
		id_pacient 
      ,[N_ZAP]
      ,[PR_NOV]
      ,[ID_PAC] 	 'PACIENT/ID_PAC' 
      ,[VPOLIS]		 'PACIENT/VPOLIS'
      ,[SPOLIS]		 'PACIENT/SPOLIS'
      ,[NPOLIS]		 'PACIENT/NPOLIS'
	  ,[ST_OKATO]	 'PACIENT/ST_OKATO'
      ,[SMO]		 'PACIENT/SMO'
      ,[SMO_OGRN]	 'PACIENT/SMO_OGRN'
      ,[SMO_OK]		 'PACIENT/SMO_OK'
      ,[SMO_NAM]	 'PACIENT/SMO_NAM'
      ,[MSE]		 'PACIENT/MSE'
      ,[NOVOR]		 'PACIENT/NOVOR'
      ,[VNOV_D]		 'PACIENT/VNOV_D'
from pacient
where id_files=@id_FILES
),
schet_out as
(
select CODE,CODE_MO,YEAR,MONTH,NSCHET,substring(convert(varchar,DSCHET,120),1,10) DSCHET,PLAT,SUMMAV
	,SUMMAV-(select sum(SANK_OUT) from vall where files_id_files=@id_FILES and IDSERV_first is not null) SUMMAP
	,COMENTS
	,(select sum(sank_mek_out) from vall where files_id_files=@id_FILES and IDSERV_first is not null) SANK_MEK
	,(select sum(sank_mee_out) from vall where files_id_files=@id_FILES and IDSERV_first is not null) SANK_MEE
	,(select sum(sank_ekmp_out) from vall where files_id_files=@id_FILES and IDSERV_first is not null) SANK_EKMP
 from files  where ID_FILES=@id_FILES
)


select @xml=
'<?xml version="1.0" encoding="windows-1251"?><ZL_LIST>'
+(SELECT [VERSION],substring(convert(varchar,GETDATE(),120),1,10) DATA
		,@name_file [FILENAME]
		,SD_Z from files where id_files=@id_files for xml path('ZGLV'))
+(select * from schet_out for xml path('SCHET'))
+(select [N_ZAP],[PR_NOV],[PACIENT/ID_PAC] ,[PACIENT/VPOLIS],[PACIENT/SPOLIS],[PACIENT/NPOLIS],[PACIENT/ST_OKATO],[PACIENT/SMO],[PACIENT/SMO_OGRN],[PACIENT/SMO_OK],[PACIENT/SMO_NAM],[PACIENT/MSE],[PACIENT/NOVOR],[PACIENT/VNOV_D]
	,(select [IDCASE],[USL_OK],[VIDPOM],[FOR_POM],[NPR_MO],[LPU],[DATE_Z_1],[DATE_Z_2]
			,(select VNOV_M from VNOV_M where VNOV_M.ID_Z_SL=z_sl.ID_Z_SL for xml path(''),type) VNOV_M
			,[RSLT],[ISHOD]
			--,'OS_SLUCH' OS_SLUCH
		,(select [SL_ID],[VID_HMP],[METOD_HMP],[LPU_1],[PODR],[PROFIL],[PROFIL_K],[DET],substring(convert(varchar,[TAL_D],120),1,10) [TAL_D],[TAL_NUM],substring(convert(varchar,[TAL_P],120),1,10) [TAL_P],[NHISTORY],substring(convert(varchar,DATE_1,120),1,10) DATE_1,substring(convert(varchar,[DATE_2],120),1,10) DATE_2,[KD],[DS0],[DS1]
				,(select DS2 from DS2 where DS2.ID_SLUCH=sluch.ID_SLUCH for xml path(''),type)
				,(select DS3 from DS3 where DS3.ID_SLUCH=sluch.ID_SLUCH for xml path(''),type)
				,(select CODE_MES1 from CODE_MES1 where CODE_MES1.ID_SLUCH=sluch.ID_SLUCH for xml path(''),type) CODE_MES1
				,[CODE_MES2],[PRVS],[VERS_SPEC],[IDDOKT],[ED_COL],[TARIF],[SUM_M]
			,(select S_CODE,S_SUM,S_TIP,S_OSN,S_COM,S_IST from SANK where SANK.sluch_id=sluch.ID_SLUCH for xml path('SANK'),type) 
			,(select [IDSERV],[LPU],[LPU_1],[PODR],[PROFIL],[VID_VME],[DET],substring(convert(varchar,[DATE_IN],120),1,10) [DATE_IN],substring(convert(varchar,[DATE_OUT],120),1,10) [DATE_OUT],[DS],[CODE_USL],[KOL_USL],[TARIF],[SUMV_USL],[PRVS],[CODE_MD],[COMENTU] from USL where USL.ID_SLUCH=sluch.ID_SLUCH for xml path('USL'),type) 
			,[COMENTSL]
			from sluch where sluch.ID_Z_SL=Z_SL.ID_Z_SL for xml path('SL'),type
		) 
		,[IDSP],[SUMV],[OPLATA],SUMV-isnull((select sum(SANK_OUT) from vall where IDSERV_first is not null and Z_SL_ID_Z_SL=ID_Z_SL),0) SUMP,isnull((select sum(SANK_OUT) from vall where IDSERV_first is not null and  Z_SL_ID_Z_SL=ID_Z_SL),0) SANK_IT
		from Z_SL where Wpacient.ID_PACIENT=Z_SL.ID_PACIENT for xml path('Z_SL'),type
	) 
	from Wpacient order by N_ZAP for xml path('ZAP')
	)

+'</ZL_LIST>'


	RETURN @xml

END
;
GO
ALTER FUNCTION [dbo].[exportHM] 
(
	@id_files int
	,@name_file varchar(20)
)
RETURNS varchar(max)
AS
BEGIN
	DECLARE @xml varchar(max);

with Wpacient as (
	select   
		id_pacient 
      ,[N_ZAP]
      ,[PR_NOV]
      ,[ID_PAC] 	 'PACIENT/ID_PAC' 
      ,[VPOLIS]		 'PACIENT/VPOLIS'
      ,[SPOLIS]		 'PACIENT/SPOLIS'
      ,[NPOLIS]		 'PACIENT/NPOLIS'
	  ,[ST_OKATO]	 'PACIENT/ST_OKATO'
      ,[SMO]		 'PACIENT/SMO'
      ,[SMO_OGRN]	 'PACIENT/SMO_OGRN'
      ,[SMO_OK]		 'PACIENT/SMO_OK'
      ,[SMO_NAM]	 'PACIENT/SMO_NAM'
	  ,[INV]		 'PACIENT/INV'
      ,[MSE]		 'PACIENT/MSE'
      ,[NOVOR]		 'PACIENT/NOVOR'
      ,[VNOV_D]		 'PACIENT/VNOV_D'
from pacient
where id_files=@id_FILES
),
schet_out as
(
select CODE,CODE_MO,YEAR,MONTH,NSCHET,substring(convert(varchar,DSCHET,120),1,10) DSCHET,PLAT,SUMMAV
	,SUMMAV-(select sum(SANK_OUT) from vall where files_id_files=@id_FILES and IDSERV_first is not null) SUMMAP
	,COMENTS
	,(select sum(sank_mek_out) from vall where IDSERV_first is not null and files_id_files=@id_FILES) SANK_MEK
	,(select sum(sank_mee_out) from vall where IDSERV_first is not null and files_id_files=@id_FILES) SANK_MEE
	,(select sum(sank_ekmp_out) from vall where IDSERV_first is not null and files_id_files=@id_FILES) SANK_EKMP
 from files  where ID_FILES=@id_FILES
)


select @xml=
'<?xml version="1.0" encoding="windows-1251"?><ZL_LIST>'
+(SELECT [VERSION],substring(convert(varchar,GETDATE(),120),1,10) DATA,@name_file [FILENAME],SD_Z from files where id_files=@id_files for xml path('ZGLV'))
+(select * from schet_out for xml path('SCHET'))
+(select [N_ZAP],[PR_NOV],[PACIENT/ID_PAC] ,[PACIENT/VPOLIS],[PACIENT/SPOLIS],[PACIENT/NPOLIS],[PACIENT/ST_OKATO],[PACIENT/SMO],[PACIENT/SMO_OGRN],[PACIENT/SMO_OK],[PACIENT/SMO_NAM],[PACIENT/INV],[PACIENT/MSE],[PACIENT/NOVOR],[PACIENT/VNOV_D]
	,(select [IDCASE],[USL_OK],[VIDPOM],[FOR_POM],[NPR_MO],substring(convert(varchar,[NPR_DATE],120),1,10) [NPR_DATE],[LPU],[DATE_Z_1],[DATE_Z_2],[KD_Z],[RSLT],[ISHOD]
			--,'OS_SLUCH' OS_SLUCH
			,[VB_P]
		,(select [SL_ID],[LPU_1],[PODR],[PROFIL],[PROFIL_K],[DET],[P_CEL],[NHISTORY],[P_PER],substring(convert(varchar,DATE_1,120),1,10) DATE_1,substring(convert(varchar,[DATE_2],120),1,10) DATE_2,[KD],[DS0],[DS1]
				,(select DS2 from DS2 where DS2.ID_SLUCH=sluch.ID_SLUCH for xml path(''),type)
				,(select DS3 from DS3 where DS3.ID_SLUCH=sluch.ID_SLUCH for xml path(''),type)
				,[DN]
				,(select CODE_MES1 from CODE_MES1 where CODE_MES1.ID_SLUCH=sluch.ID_SLUCH for xml path(''),type) CODE_MES1
				,[CODE_MES2]
				,(select [N_KSG],[VER_KSG],[KSG_PG],[N_KPG],[KOEF_Z],[KOEF_UP],[BZTSZ],[KOEF_D],[KOEF_U],[DKK1],[DKK2],[SL_K],[IT_SL] from KSG_KPG where KSG_KPG.ID_SLUCH=sluch.ID_SLUCH for xml path('KSG_KPG'),type) 
				,[REAB],[PRVS],[VERS_SPEC],[IDDOKT],[ED_COL],[TARIF],[SUM_M]
			,(select S_CODE,S_SUM,S_TIP,S_OSN,S_COM,S_IST from SANK where SANK.sluch_id=sluch.ID_SLUCH for xml path('SANK'),type) 
			,(select [IDSERV],[LPU],[LPU_1],[PODR],[PROFIL],[VID_VME],[DET],substring(convert(varchar,[DATE_IN],120),1,10) [DATE_IN],substring(convert(varchar,[DATE_OUT],120),1,10) [DATE_OUT],[DS],[CODE_USL],[KOL_USL],[TARIF],[SUMV_USL],[PRVS],[CODE_MD],[NPL],[COMENTU] from USL where USL.ID_SLUCH=sluch.ID_SLUCH for xml path('USL'),type) 
			,[COMENTSL]
			from sluch where sluch.ID_Z_SL=Z_SL.ID_Z_SL for xml path('SL'),type
		) 
		,[IDSP],[SUMV],[OPLATA],SUMV-isnull((select sum(SANK_OUT) from vall where IDSERV_first is not null and Z_SL_ID_Z_SL=ID_Z_SL),0) SUMP,isnull((select sum(SANK_OUT) from vall where IDSERV_first is not null and Z_SL_ID_Z_SL=ID_Z_SL),0) SANK_IT
		from Z_SL where Wpacient.ID_PACIENT=Z_SL.ID_PACIENT for xml path('Z_SL'),type
	) 
	from Wpacient order by N_ZAP for xml path('ZAP')
	)

+'</ZL_LIST>'


	RETURN @xml

END
;
GO
ALTER FUNCTION [dbo].[exportDisp] 
(
	@id_files int
	,@name_file varchar(20)
)
RETURNS varchar(max)
AS
BEGIN
	DECLARE @xml varchar(max);

with Wpacient as (
	select   
		id_pacient 
      ,[N_ZAP]
      ,[PR_NOV]
      ,[ID_PAC] 	 'PACIENT/ID_PAC' 
      ,[VPOLIS]		 'PACIENT/VPOLIS'
      ,[SPOLIS]		 'PACIENT/SPOLIS'
      ,[NPOLIS]		 'PACIENT/NPOLIS'
	  ,[ST_OKATO]	 'PACIENT/ST_OKATO'
      ,[SMO]		 'PACIENT/SMO'
      ,[SMO_OGRN]	 'PACIENT/SMO_OGRN'
      ,[SMO_OK]		 'PACIENT/SMO_OK'
      ,[SMO_NAM]	 'PACIENT/SMO_NAM'
      ,[NOVOR]		 'PACIENT/NOVOR'
from pacient
where id_files=@id_FILES
),
schet_out as
(
select CODE,CODE_MO,YEAR,MONTH,NSCHET,substring(convert(varchar,DSCHET,120),1,10) DSCHET,PLAT,SUMMAV
	,SUMMAV-(select sum(SANK_OUT) from vall where files_id_files=@id_FILES and IDSERV_first is not null) SUMMAP
	,COMENTS
	,(select sum(sank_mek_out) from vall where IDSERV_first is not null and files_id_files=@id_FILES) SANK_MEK
	,(select sum(sank_mee_out) from vall where IDSERV_first is not null and files_id_files=@id_FILES) SANK_MEE
	,(select sum(sank_ekmp_out) from vall where IDSERV_first is not null and files_id_files=@id_FILES) SANK_EKMP
	,DISP
 from files  where ID_FILES=@id_FILES
)


select @xml=
'<?xml version="1.0" encoding="windows-1251"?><ZL_LIST>'
+(SELECT [VERSION],substring(convert(varchar,GETDATE(),120),1,10) DATA
	,@name_file [FILENAME]
	,SD_Z from files where id_files=@id_files for xml path('ZGLV'))
+(select * from schet_out for xml path('SCHET'))
+(select [N_ZAP],[PR_NOV],[PACIENT/ID_PAC] ,[PACIENT/VPOLIS],[PACIENT/SPOLIS],[PACIENT/NPOLIS],[PACIENT/ST_OKATO],[PACIENT/SMO],[PACIENT/SMO_OGRN],[PACIENT/SMO_OK],[PACIENT/SMO_NAM],[PACIENT/NOVOR]
	,(select [IDCASE],[VIDPOM],[LPU],[VBR],[DATE_Z_1],[DATE_Z_2],[P_OTK],[RSLT_D]
			--,'OS_SLUCH' OS_SLUCH
		,(select [SL_ID],[LPU_1],[NHISTORY],substring(convert(varchar,DATE_1,120),1,10) DATE_1,substring(convert(varchar,[DATE_2],120),1,10) DATE_2,[DS1],DS1_PR,PR_D_N
				,(select DS2,DS2_PR,PR_DS2_N from DS2_N where DS2_N.ID_SLUCH=sluch.ID_SLUCH for xml path('DS2_N'),type)
				,(select NAZ_N,NAZ_R,NAZ_SP,NAZ_V,NAZ_PMP,NAZ_PK from NAZ where NAZ.ID_SLUCH=sluch.ID_SLUCH for xml path('NAZ'),type)

				,[ED_COL],[TARIF],[SUM_M]
			,(select S_CODE,S_SUM,S_TIP,S_OSN,S_COM,S_IST from SANK where SANK.sluch_id=sluch.ID_SLUCH for xml path('SANK'),type) 
			,(select [IDSERV],[LPU],[LPU_1],[PODR],substring(convert(varchar,[DATE_IN],120),1,10) [DATE_IN],substring(convert(varchar,[DATE_OUT],120),1,10) [DATE_OUT],P_OTK,[CODE_USL],[TARIF],[SUMV_USL],[PRVS],[CODE_MD],[COMENTU] from USL where USL.ID_SLUCH=sluch.ID_SLUCH for xml path('USL'),type) 
			,[COMENTSL]
			from sluch where sluch.ID_Z_SL=Z_SL.ID_Z_SL for xml path('SL'),type
		) 
		,[IDSP],[SUMV],[OPLATA],SUMV-isnull((select sum(SANK_OUT) from vall where IDSERV_first is not null and Z_SL_ID_Z_SL=ID_Z_SL),0) SUMP,isnull((select sum(SANK_OUT) from vall where IDSERV_first is not null and Z_SL_ID_Z_SL=ID_Z_SL),0) SANK_IT
		from Z_SL where Wpacient.ID_PACIENT=Z_SL.ID_PACIENT for xml path('Z_SL'),type
	) 
	from Wpacient order by N_ZAP for xml path('ZAP')
	)

+'</ZL_LIST>'


	RETURN @xml

END
;